C      *****************************************************************
C      * Subroutine PivotMatrix                                        *
C      * Sets up the order array so that Order(1) contains the row #   *
C      * for the row with the largest coefficient in the first column, *
C      * Order(2) contains the row # with the largest coefficient for  *
C      * the second column excluding the row in Order(1), Order(3)     *
C      * contains the row # with the largest coefficient for the       *
C      * third column excluding the rows in Order(1) and Order(2), etc.*
C      *                                                               *
C      * Variables:                                                    *
C      * A         -Input - A matrix of size "Size" by ("Size"+1).     *
C      *                    The "Size" by "Size" portion of the matrix *
C      *                    contains the coefficents of "Size"         *
C      *                    equations in "Size" unknowns, and the      *
C      *                    "Size"+1st column is the right hand side   *
C      *                    vector of constant terms.  "Size" is equal *
C      *                    to the number of components in the system. *
C      *                    Units are consistent with inputs.          *
C      *                    (Common block VGauss, file VGauss.f).      *
C      * Check     -Local - The coefficient in the current row to check*
C      *                    against the maximum.  Unitless.            *
C      * Max       -Local - The maximum coefficient found so far.      *
C      *                    Unitless.                                  *
C      * Order     -Output- A vector of size "Size" which orders the   *
C      *                    rows of A so that in this order A is an    *
C      *                    upper triangular matrix.  Unitless.        *
C      *                    (Common block VGauss, file VGauss.f).      *
C      * P         -Input - The amount of phosphorus in organic        *
C      *                    matter.  Units are g P.                    *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * Pivot     -Local - The row which belongs in the current       *
C      *                    position P in the creation of the upper    *
C      *                    triangular A.  Unitless.                   *
C      * Row       -Local - Row index into matrix A.  Unitless.        *
C      * Size      -Input - The number of chemical components in the   *
C      *                    system.  Unitless.                         *
C      *                    (Common block VGauss, file VGauss.f).      *
C      *****************************************************************
       SUBROUTINE PIVOTMATRIX(P)
							IMPLICIT NONE
							INCLUDE 'VGAUSS.INC'
							INTEGER P, PIVOT, ROW
							REAL*8 CHECK, MAX

C      *-----------------------------------------------------------*
C      * Set the input row number as the pivot point and its       *
C      * diagonal term as the maximum coefficient for that column. *
C      *-----------------------------------------------------------*
	      PIVOT = P
							MAX = ABS(A(ORDER(P),P))

C      *-----------------------------------------------------------*
C      * Check all rows after this row for a value larger than the *
C      * largest value found for this column so far.               *
C      *-----------------------------------------------------------*
	      DO 100 ROW=P+1,SIZE
	         CHECK = ABS(A(ORDER(ROW),P))
		        IF (CHECK.GT.MAX) THEN
      		     MAX = CHECK
        			 PIVOT = ROW
      		  ENDIF
 100   CONTINUE

C      *---------------------------------------------------------------*
C      * Replace the row with the largest value in the Pth column with *
C      * the passed row.                                               *
C      *---------------------------------------------------------------*
       CALL SWAP(ORDER(PIVOT), ORDER(P))
	 	  
	      RETURN
   	   END 
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
